package com.ptk671.pffloader.api.block;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import java.util.function.ToIntFunction;

public class PffBlockSettings {

    private final FabricBlockSettings settings;

    public PffBlockSettings() {
        this.settings = FabricBlockSettings.method_9637(class_3614.field_15914);
    }

    public PffBlockSettings copyOf(PffBlock pffBlock) {
        FabricBlockSettings.method_9630(pffBlock);
        return this;
    }

    public PffBlockSettings copyOf(PffBlockSettings pffBlockSetting) {
        FabricBlockSettings.copyOf(pffBlockSetting.build());
        return this;
    }

    public PffBlockSettings air() {
        //not support
        return this;
    }

/*
    public PffBlockSettings blockVision(AbstractBlock.ContextPredicate predicate) {
        settings.blockVision(predicate);
        return this;
    }

    public PffBlockSettings postProcess(AbstractBlock.ContextPredicate predicate) {
        settings.postProcess(predicate);
        return this;
    }

    public PffBlockSettings solidBlock(AbstractBlock.ContextPredicate predicate) {
        settings.solidBlock(predicate);
        return this;
    }

    public PffBlockSettings suffocates(AbstractBlock.ContextPredicate predicate) {
        settings.suffocates(predicate);
        return this;
    }

    @Deprecated
    public PffBlockSettings MaterialColor(Function<BlockState, MaterialColor> color) {
        return this;
    }
*/
    public PffBlockSettings dropsLike(class_2248 source) {
        settings.method_16228(source);
        return this;
    }

    public PffBlockSettings breakInstantly() {
        settings.method_9618();
        return this;
    }

    public PffBlockSettings dropsNothing() {
        settings.method_16229();
        return this;
    }

    public PffBlockSettings dynamicBounds() {
        settings.dynamicBounds();
        return this;
    }

    public PffBlockSettings noBlockBreakParticles() {
        return this;
    }

    public PffBlockSettings requiresTool() {
        //not support
        return this;
    }

    public PffBlockSettings noCollision() {
        settings.method_9634();
        return this;
    }

    public PffBlockSettings nonOpaque() {
        //not support
        return this;
    }

    public PffBlockSettings strength(Float strength) {
        settings.method_9632(strength);
        return this;
    }

    public PffBlockSettings strength(Float hardness, Float resistance) {
        settings.method_9629(hardness,resistance);
        return this;
    }


    public PffBlockSettings ticksRandomly() {
        settings.method_9640();
        return this;
    }

    public PffBlockSettings sounds(class_2498 blockSoundGroup) {
        settings.method_9626(blockSoundGroup);
        return this;
    }

    public PffBlockSettings luminance(ToIntFunction<class_2680> luminance) {
        //not support
        return this;
    }

    public PffBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        //not support
        return this;
    }

    public PffBlockSettings slipperiness(float slipperiness) {
        settings.method_9628(slipperiness);
        return this;
    }

    public PffBlockSettings velocityMultiplier(float velocityMultiplier) {
        //not support
        return this;
    }

    /*

    public PffBlockSettings emissiveLighting(AbstractBlock.ContextPredicate predicate) {
        //not support
        return this;
    }

    public PffBlockSettings allowsSpawning(FabricBlockSettings.TypedContextPredicate<net.minecraft.entity.EntityType<?>> predicate) {
        //not support
        return this;
    }
*/
    public FabricBlockSettings build() {
        return settings;
    }
}